package com.qboxus.tictic.activitesfragments.livestreaming.adapter

import android.content.Context
import android.net.Uri
import android.text.TextUtils
import android.view.LayoutInflater
import android.view.ViewGroup
import androidx.databinding.DataBindingUtil
import androidx.recyclerview.widget.RecyclerView
import com.qboxus.tictic.R
import com.qboxus.tictic.activitesfragments.livestreaming.model.GiftUsers
import com.qboxus.tictic.databinding.ItemTopGifterBinding
import com.qboxus.tictic.interfaces.AdapterClickListener
import com.facebook.drawee.backends.pipeline.Fresco
import com.facebook.drawee.interfaces.DraweeController
import com.facebook.imagepipeline.request.ImageRequestBuilder
import com.qboxus.tictic.simpleclasses.Functions.frescoImageLoad

class TopGifterAdapter(
    var context: Context,
    user_dataList: List<GiftUsers>,
    listener: AdapterClickListener
) : RecyclerView.Adapter<TopGifterAdapter.CustomViewHolder>() {
    var user_dataList: List<GiftUsers> = ArrayList()
    var adapterClickListener: AdapterClickListener
    init {
        this.user_dataList = user_dataList
        this.adapterClickListener = listener
    }

    override fun onCreateViewHolder(viewGroup: ViewGroup, viewtype: Int): CustomViewHolder {
        val binding = DataBindingUtil.inflate<ItemTopGifterBinding>(
            LayoutInflater
                .from(viewGroup.context), R.layout.item_top_gifter, viewGroup, false
        )
        return CustomViewHolder(binding)
    }

    override fun getItemCount(): Int {
        return user_dataList.size
    }

    override fun onBindViewHolder(holder: CustomViewHolder, i: Int) {

        val item = user_dataList[i]
        if (!TextUtils.isEmpty(item.userPicture)) {
            holder.binding.ivMainProfile.controller = frescoImageLoad(item.userPicture,
                holder.binding.ivMainProfile, false)
        }

    }

    inner class CustomViewHolder(var binding: ItemTopGifterBinding) : RecyclerView.ViewHolder(
        binding.root
    ) {
    }

}